<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '3.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}

add_action( 'after_setup_theme', 'childtheme_formats', 11 );
function childtheme_formats(){
     add_theme_support( 'post-formats', array('aside', 'quote', 'status', 'image', 'gallery', 'chat', 'link', 'audio', 'video') ); }

add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );

// Disable all WP image sizes except the 150x150 thumbnail
function disable_image_sizes($sizes) {
    unset($sizes['medium']);         // ~300px
    unset($sizes['medium_large']);   // ~768px
    unset($sizes['large']);          // ~1024px
    unset($sizes['1536x1536']);      // ~1536px
    unset($sizes['2048x2048']);      // ~2048px
    unset($sizes['thumbnail']);      // We'll handle this manually below
    unset($sizes['120x120']);        // Custom small size
    unset($sizes['200x200']);        // Custom square size
    return $sizes;
}
add_filter('intermediate_image_sizes_advanced', 'disable_image_sizes');

// Re-register only the 150x150 thumbnail
function allow_only_150_thumbnail() {
    update_option('thumbnail_size_w', 150);
    update_option('thumbnail_size_h', 150);
    update_option('thumbnail_crop', 1);
}
add_action('init', 'allow_only_150_thumbnail');

// Remove any additional custom sizes from plugins/themes
function remove_additional_image_sizes() {
    foreach (get_intermediate_image_sizes() as $size) {
        if ($size !== 'thumbnail') {
            remove_image_size($size);
        }
    }
}
add_action('init', 'remove_additional_image_sizes', 100);